import { jsx, jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "../primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "../primitives/Button/TldrawUiButtonIcon.mjs";
import {
  TldrawUiDropdownMenuContent,
  TldrawUiDropdownMenuItem,
  TldrawUiDropdownMenuRoot,
  TldrawUiDropdownMenuTrigger
} from "../primitives/TldrawUiDropdownMenu.mjs";
function _DoubleDropdownPicker({
  label,
  uiTypeA,
  uiTypeB,
  labelA,
  labelB,
  itemsA,
  itemsB,
  styleA,
  styleB,
  valueA,
  valueB,
  onValueChange
}) {
  const msg = useTranslation();
  const iconA = React.useMemo(
    () => itemsA.find((item) => valueA.type === "shared" && valueA.value === item.value)?.icon ?? "mixed",
    [itemsA, valueA]
  );
  const iconB = React.useMemo(
    () => itemsB.find((item) => valueB.type === "shared" && valueB.value === item.value)?.icon ?? "mixed",
    [itemsB, valueB]
  );
  if (valueA === void 0 && valueB === void 0) return null;
  return /* @__PURE__ */ jsxs("div", { className: "tlui-style-panel__double-select-picker", children: [
    /* @__PURE__ */ jsx("div", { title: msg(label), className: "tlui-style-panel__double-select-picker-label", children: msg(label) }),
    /* @__PURE__ */ jsxs("div", { className: "tlui-buttons__horizontal", children: [
      /* @__PURE__ */ jsxs(TldrawUiDropdownMenuRoot, { id: `style panel ${uiTypeA} A`, children: [
        /* @__PURE__ */ jsx(TldrawUiDropdownMenuTrigger, { children: /* @__PURE__ */ jsx(
          TldrawUiButton,
          {
            type: "icon",
            "data-testid": `style.${uiTypeA}`,
            title: msg(labelA) + " \u2014 " + (valueA === null || valueA.type === "mixed" ? msg("style-panel.mixed") : msg(`${uiTypeA}-style.${valueA.value}`)),
            children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: iconA, small: true, invertIcon: true })
          }
        ) }),
        /* @__PURE__ */ jsx(TldrawUiDropdownMenuContent, { side: "left", align: "center", sideOffset: 80, alignOffset: 0, children: /* @__PURE__ */ jsx("div", { className: "tlui-buttons__grid", children: itemsA.map((item, i) => {
          return /* @__PURE__ */ jsx(TldrawUiDropdownMenuItem, { "data-testid": `style.${uiTypeA}.${item.value}`, children: /* @__PURE__ */ jsx(
            TldrawUiButton,
            {
              type: "icon",
              onClick: () => onValueChange(styleA, item.value),
              title: `${msg(labelA)} \u2014 ${msg(`${uiTypeA}-style.${item.value}`)}`,
              children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: item.icon, invertIcon: true })
            },
            item.value
          ) }, i);
        }) }) })
      ] }),
      /* @__PURE__ */ jsxs(TldrawUiDropdownMenuRoot, { id: `style panel ${uiTypeB}`, children: [
        /* @__PURE__ */ jsx(TldrawUiDropdownMenuTrigger, { children: /* @__PURE__ */ jsx(
          TldrawUiButton,
          {
            type: "icon",
            "data-testid": `style.${uiTypeB}`,
            title: msg(labelB) + " \u2014 " + (valueB === null || valueB.type === "mixed" ? msg("style-panel.mixed") : msg(`${uiTypeB}-style.${valueB.value}`)),
            children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: iconB, small: true })
          }
        ) }),
        /* @__PURE__ */ jsx(TldrawUiDropdownMenuContent, { side: "left", align: "center", sideOffset: 116, alignOffset: 0, children: /* @__PURE__ */ jsx("div", { className: "tlui-buttons__grid", children: itemsB.map((item) => {
          return /* @__PURE__ */ jsx(TldrawUiDropdownMenuItem, { children: /* @__PURE__ */ jsx(
            TldrawUiButton,
            {
              type: "icon",
              title: `${msg(labelB)} \u2014 ${msg(`${uiTypeB}-style.${item.value}`)}`,
              "data-testid": `style.${uiTypeB}.${item.value}`,
              onClick: () => onValueChange(styleB, item.value),
              children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: item.icon })
            }
          ) }, item.value);
        }) }) })
      ] })
    ] })
  ] });
}
const DoubleDropdownPicker = React.memo(
  _DoubleDropdownPicker
);
export {
  DoubleDropdownPicker
};
//# sourceMappingURL=DoubleDropdownPicker.mjs.map
